<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.CodeResultSelection" Theme="Voxco"
    Trace="false" Async="true" Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="CodeResultSelection.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">		   
		<script type="text/javascript">

		    if (Telerik.Web.UI.RadTreeView != undefined) {
		        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
		            return "{\"expandedNodes\":" + this._expandedNodesJson +
		                ",\"collapsedNodes\":" + this._collapsedNodesJson +
		                ",\"logEntries\":" + this._logEntriesJson +
		                ",\"selectedNodes\":" + this._selectedNodesJson +
		                ",\"checkedNodes\":" + this._checkedNodesJson +
		                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
		        }
		    }

			function treeSelectedDropTest(source, dest, events)
			{
//				if(dest.Value.substring(0, 3) == "OG:" && source.Parent != null && source.Parent.Value != dest.Value)
//				{
//					return true;
//				}
//				// allow moving all group's elements in another group
//				if(source.Value.substring(0, 3) == "OG:" && dest.Value.substring(0, 3) == "OG:")
//				{
//					return true;
//				}
//				return false;
			}
	        
			function ContextMenuClick(node, itemText)
			{
				if (itemText == "Disable")
				{
					node.Disable();
					return false;
				}
				if (itemText == "Enable All")
				{
					for (var i=0; i<node.TreeView.AllNodes.length; i++)
					{
						node.TreeView.AllNodes[i].Enable();
					}
				}
				if (itemText == "Edit")
				{        
					node.StartEdit();
				}
	            
				return true;
			}
	        
			function UpdateAllChildren(nodes, checked)
			{
				for (i=0; i<nodes.length; i++)
				{
					checked ? nodes[i].check() : nodes[i].uncheck(); 
					if (nodes[i].Nodes.length > 0)
					{
						UpdateAllChildren(nodes[i].Nodes, checked);    
					}
				}
			}
	        
			function UncheckGroupNodesAllNodes()
			{
				var tree = $find("<%= treeSelectedResultCodes.ClientID %>"); 
			    var _nodes = tree.get_allNodes();
				for (var i = 0; i < _nodes.length; i++)
				{
					if( _nodes[i].get_value().substring(0, 3) == "OG:" )
					{
						_nodes[i].uncheck();
					}
				}				
			}

			function CheckGroupNodesAllNodes()
			{
				var tree = $find("<%= treeSelectedResultCodes.ClientID %>"); 
			    var _nodes = tree.get_allNodes();
				for (var i = 0; i < _nodes.length; i++)
				{
					if( _nodes[i].get_value().substring(0, 3) == "OG:" )
					{
						_nodes[i].check();
					}
				}
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes"); 
			}
	        
			function OnCheckedNode(node)
			{			
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
			}
	    
			function RefreshResultCodesSelection()
			{			
				 $find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("RefreshTree");
			}
		</script>
	</telerik:RadScriptBlock>
    
    <div id="toolTip" style="position: absolute; visibility: hidden; background-color:InfoBackground;
        border: 1px solid black; padding: 0.2em; font-size: 8pt; font-family: Tahoma;">
    </div>
    
    <!-- START OBJECT DATA SOURCE -->
    
    <asp:ObjectDataSource ID="SelectedResultCodeDataSource" runat="server" SelectMethod="GetGenericSelected"
        TypeName="Voxco.Reporting.DataSource.ResultCodes">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="AvailableResultCodeDataSource" runat="server" SelectMethod="GetGenericAvailable"
        TypeName="Voxco.Reporting.DataSource.ResultCodes"></asp:ObjectDataSource>
        
    <asp:ObjectDataSource ID="FilteredResultCodeDataSource" runat="server" SelectMethod="GetGenericFiltered"
        TypeName="Voxco.Reporting.DataSource.ResultCodes"></asp:ObjectDataSource>
        
	<asp:ObjectDataSource ID="LanguagesDataSource" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.LanguagesDS">
    </asp:ObjectDataSource>    
    
    <!-- END OBJECT DATA SOURCE -->
    
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="MainAjaxManager_OnAjaxRequest">
		<br />
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25">
                <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
        </telerik:RadAjaxLoadingPanel>
        
        <asp:RadioButtonList ID="choiceSelectionType" runat="server" Visible="false" RepeatDirection="Horizontal" 
            AutoPostBack="true" OnSelectedIndexChanged="choiceSelectionType_OnSelectedIndexChanged">
            <asp:ListItem Value="AllInterviewers" Text="<%$ Resources:Resource, AllResultCodes%>" Selected="True"></asp:ListItem>
            <asp:ListItem Value="SelectInterviewers" Text="<%$ Resources:Resource, SelectResultCodes%>"></asp:ListItem>
        </asp:RadioButtonList>
        
        <asp:Panel ID="IncludeAllResultCodesLabel" runat="server" GroupingText=" " Visible="false">
			<asp:Label ID="IncludeAllResultCodesLabel2" runat="server" Text="<%$ Resources:Resource, AllAvailableResultCodesWillBeSelected %>"></asp:Label>
        </asp:Panel>
        
        <asp:Panel ID="RadSplitter2" runat="server">
			
			<div runat="server" id="DataLanguageListDiv" style="margin-bottom: 5px; padding-left: 10px;"> 
				<asp:Label ID="DataLanguageLabel" runat="server"  Text="<%$ Resources:Resource, ResultCodeLabelLanguage %>"></asp:Label>:
				<asp:DropDownList ID="DataLanguageList" runat="server" OnDataBound="DataLanguageList_DataBound" Font-Size="8pt" Width="155px" DataSourceID="LanguagesDataSource" AutoPostBack="true"  DataTextField="LanguageLabel" DataValueField="LanguageCode" OnSelectedIndexChanged="DataLanguageList_SelectedIndexChanged"/>
			</div>

				<div style="float:left; width: 30%;">
			
					<asp:Label ID="TitleAvailableResultCodes" runat="server" Text="<%$ Resources:Resource, AvailableResultCodes %>" CssClass="title"></asp:Label>
						
                    <telerik:RadGrid id="grdAvailableResultCodes" runat="server" AutoGenerateColumns="False"
                    AllowMultiRowSelection="True" DataSourceID="AvailableResultCodeDataSource"
                    AllowSorting="True" OnSortCommand="AvailableResultCodes_SortCommand" 
                    SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>" 
                    SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>"  
                    SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>"
                    Height="350px" EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						<ClientSettings>
							<Selecting AllowRowSelect="True" UseClientSelectColumnOnly="true"  />
							<Scrolling AllowScroll="true" UseStaticHeaders="True"  />
						</ClientSettings>
						<MasterTableView DataSourceID="AvailableResultCodeDataSource"  NoMasterRecordsText="<%$ Resources:Resource, NoRecords %>" Width="100%">
							<SortExpressions>
								<telerik:GridSortExpression FieldName="CodeText" />
							</SortExpressions>
							<Columns>
								<telerik:GridBoundColumn DataField="Code" DataType="System.Int32" Display="False" HeaderText="Code" UniqueName="Code">
								</telerik:GridBoundColumn>
								<telerik:GridBoundColumn DataField="ProjectId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
								</telerik:GridBoundColumn>
								<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
									<HeaderStyle Width="10%" HorizontalAlign="Left" />
									<ItemStyle Width="10%" HorizontalAlign="Left" />
								</telerik:GridClientSelectColumn>
								<telerik:GridBoundColumn DataField="CodeText" HeaderText="<%$ Resources:Resource, AvailableResultCodes %>" UniqueName="CodeText">                                                
									<HeaderStyle Width="85%" HorizontalAlign="left" />
									<ItemStyle Wrap="false" Width="85%" HorizontalAlign="left" />
								</telerik:GridBoundColumn>
							</Columns>
						</MasterTableView>                                    
                        <SortingSettings SortedAscToolTip="Click here to sort" SortedDescToolTip="Click here to sort" />
                    </telerik:RadGrid>
						
				</div>
					
                <div style="float: left; margin-top: 150px; width: 25px; text-align:center;">
						
					<asp:ImageButton ID="btnAddFilteredResultCode" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>"
                    OnClick="btnAddFilteredResultCode_OnClick" />
                    <br />
                    <br />
                    <asp:ImageButton ID="btnRemoveFilteredResultCode" runat="server" ImageUrl="~/icons/arrow_left_blue.png" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>"
                    OnClick="btnRemoveFilteredResultCode_OnClick" />
				</div>
					
				<div style="float: left; width: 30%;">
					
					<asp:Label ID="TitleFilteredResultCode" runat="server" Text="<%$ Resources:Resource, FilteredResultCodes %>" CssClass="title"></asp:Label>
					
					<telerik:RadGrid ID="grdFilteredResultCodes" runat="server" AllowSorting="True" DataSourceID="FilteredResultCodeDataSource" Height="350px"
					OnSortCommand="FilteredResultCodes_SortCommand" SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>"
					SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>" SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>" 
                    AllowMultiRowSelection="True" AutoGenerateColumns="False" EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						<ClientSettings>
							<Selecting AllowRowSelect="True" UseClientSelectColumnOnly="true" />
							<Scrolling AllowScroll="true" UseStaticHeaders="True" />
						</ClientSettings>
						<MasterTableView DataSourceID="FilteredResultCodeDataSource" NoMasterRecordsText="<%$ Resources:Resource, NoRecords %>" HorizontalAlign="NotSet" Width="100%">
							<SortExpressions>
								<telerik:GridSortExpression FieldName="CodeText" />
							</SortExpressions>
							<Columns>
								<telerik:GridBoundColumn DataField="Code" Display="False" HeaderText="Code" UniqueName="Code">
								</telerik:GridBoundColumn>
								<telerik:GridBoundColumn DataField="ProjectId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
								</telerik:GridBoundColumn>
								<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
									<HeaderStyle Width="10%" HorizontalAlign="Left" />
									<ItemStyle Width="10%" HorizontalAlign="Left"/>
								</telerik:GridClientSelectColumn>
								<telerik:GridBoundColumn DataField="CodeText" HeaderText="<%$ Resources:Resource, FilteredResultCodes %>" UniqueName="CodeText">
									<HeaderStyle Width="85%" HorizontalAlign="left" />
									<ItemStyle Width="85%" HorizontalAlign="left" Wrap="false" />
								</telerik:GridBoundColumn>
							</Columns>
						</MasterTableView>                                
					</telerik:RadGrid>  
                                   
                </div>
                    
                <div id="DisplaySelection" runat="server" style="width: 25px; float: left; margin-top: 150px;">   
					<asp:ImageButton ID="btnAddResultCode" runat="server" ImageUrl="~/icons/arrow_right_blue.png"
						OnClick="btnAddResultCode_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />
					<br />
					<br />
					<asp:ImageButton ID="btnAddResultCodeToNewGroup" runat="server" ImageUrl="~/icons/arrow_right_green.png"
						OnClick="btnAddResultCodeToNewGroup_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
					<br />
					<br />
					<asp:ImageButton ID="btnRemoveResultCode" runat="server" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveResultCode_OnClick" />  
               </div>     
               
        <div id="RadPaneResultCodesSelection" runat="server" style="float: left; width: 30%; height: 350px;">            
           
			<telerik:RadAjaxPanel ID="RadAjaxPanelTree" runat="server" EnableAJAX="true" ClientEvents-OnResponseEnd="RefreshResultCodesSelection()">
                    
				<asp:Label ID="TitleDisplayedResultCodes" runat="server" Text="<%$ Resources:Resource, DisplayedResultCodes %>" CssClass="title"></asp:Label>
				<div style="height: 335px;" class="frame">
		        
					<asp:Label ID="labelSelectedItems" runat="server" CssClass="sectionTitle" Text="<%$ Resources:Resource, DisplayedResultCodes %>" />
					<br/>
					<asp:LinkButton ID="linkSelectAll" OnClientClick="javascript:CheckGroupNodesAllNodes();" runat="server" Font-Size="10" Text="<%$ Resources:Resource, SelectAll %>" ></asp:LinkButton>
					<asp:LinkButton ID="LinkButton1" OnClientClick="javascript:UncheckGroupNodesAllNodes();" runat="server" Font-Size="10" Text="<%$ Resources:Resource, UnselectAll %>"></asp:LinkButton>
					<asp:LinkButton ID="lnkMoveUp" runat="server" Text="<%$ Resources:Resource, MoveUp %>" OnClick="lnkMoveUp_Click" Font-Size="10"></asp:LinkButton>
					<asp:LinkButton ID="lnkMoveDown" runat="server" Text="<%$ Resources:Resource, MoveDown %>" OnClick="lnkMoveDown_Click" Font-Size="10"></asp:LinkButton>

					<telerik:radtreeview Visible="true"
						id="treeSelectedResultCodes"                            
						OnNodeEdit="treeSelectedResultCodes_HandleNodeEdit" 
						AllowNodeEditing="True" 
						SingleExpandPath="False" 
						OnClientNodeDropping="treeSelectedDropTest"
						OnClientNodeChecked="OnCheckedNode"
						MultipleSelect="True" 
						CheckBoxes="True"                                 
						DataValueField="NodeId"
						DataTextField="NodeLabel"
						DataFieldID="NodeId"
						DataFieldParentID="ParentNodeId"
						OnNodeDataBound="treeSelectedResultCodes_OnNodeBound"
						OnNodeDrop="treeSelectedResultCodes_HandleDrop"   
						EnableDragAndDrop="true"
						EnableDragAndDropBetweenNodes="true"
						DataSourceID="SelectedResultCodeDataSource"
						runat="server" Height="310px">
					</telerik:radtreeview>
					
				</div>  
            </telerik:RadAjaxPanel>                 
        </div>
    </asp:Panel>
        
    </telerik:RadAjaxPanel>
    
</asp:Content>

